################################################
#          Trigger Compiler v1.0 beta          #
#   (C) Copyright David "Moneran" James 1998   #
################################################ 
# License Agreement:                           #
# This code may not be distributed in any way  #
# other than in its complete, unmodified form  #
# without express permission from me.          #
################################################
# ("me") = copyright holder :) (Duh.)          #
# ("you") = you (Duh.)                         #
################################################
# That also means that you can't use code      #
# from this program in your own programs.      #
# E-mail me at beta@home.com, and I will       #
# consider letting you use the code.           #
################################################
# Suggestions? Bugs? Want to write your own    #
# features?  E-mail me at beta@home.com        #
################################################

$| = 1; # Bypass internal perl buffer


print q~
################################################
#          Trigger Compiler v1.0 beta          #
#   (C) Copyright David "Moneran" James 1998   #
#                                              #
# Special thanks to King Arthur for his help   #
# with the trigger file format.                #  
################################################ 
# Suggestions? Bugs? Want to write your own    #
# features?  E-mail me at beta@home.com        #
################################################
Possible features in future:
1) Windows Interface
2) Importing and exporting directly with scums
3) Compiled from Perl into a C++ EXE
If you can help me with any of these, please e-mail me! (beta@home.com)

Visit http://camelot.warzone.com for the newest version.

~;

unless (defined($ARGV[0]) && defined($ARGV[1]))
{
	print q~Usage:
text2trg input_trigger.txt output_file.trg [-d]
~;
	exit(0);
}

my $file_to_open = $ARGV[0];
my $file_to_write = $ARGV[1];
my $debug = "";

if ($ARGV[2] eq "-d")
{
	$debug = "yes";
}

print "Reading trigcomp.ini...";
open (FILE, "trigcomp.ini") or 
	&error(__FILE__,__LINE__,"Error opening trigcomp.ini. Make sure that the file is there and that the file permissions are set.");

my ($temp_integer, $temp_string) = "";
unless (-e $file_to_open) # -e = file exists
{
	print "File '$file_to_open' does not exist.";
	exit(0);
}

unless (-r $file_to_open) # -r = file is readable
{
	print "File '$file_to_open' must be readable.";
	exit(0);
}

my $current_section = "none";
my @printout;
my ($count, $count2, $count3, $number_to_modify) = 0;
my (@line,@test, $cond,$translation,$hex_code,$input,@currentPlayers,
    @actionList, @actionNum, @actions,
    %units,
    %players,
    @currentList, @currentNum, @currents,
    @conditionList, @conditionNum, @conditions,
    %aliases, %scoretype, %switchvalue, %modifiervalue, %aiscripts) = "";
$count=0;
LINE: while ($input = <FILE>)
{
	$count++;
	chomp $input; # chomp off the newline character
	$input=~ s/#.*//g; # Delete Comments
	$input=~ s/\s{2,}/ /g;
	$input=~ s/\s=\s/=/;
	$input=~ s/\s$//;
	$input=~ s/^\s//;
	if ($input eq "") # if we've already deleted
	{
		next LINE;
	} # end if (!$input)
	if ($input =~ /^\s*\[(.+)\]/)
	{
		($current_section="$1") =~ tr/A-Z/a-z/;
	} # end if ($input =~ /^\[/i)

	if ($input =~ /=/i)
	{
		@line = split (/=/,$input);
		@test=split (/:/, pop(@line));
		push(@line, @test);
		if ($current_section =~ /action/i)
		{
			push(@actionList,shift(@test));
			push(@actionNum,$#actions+2);
			push(@actions,@line);
		} # end if ($current_section =~ /action/i)
		elsif ($current_section =~ /condition/i)
		{
			push(@conditionList,shift(@test));
			push(@conditionNum,$#conditions+2);						
			push(@conditions,@line);				
		} # end if ($current_section =~ /condition/i)
		else
		{
			$test[0] =~ s/\\/\\\\/g;
			$test[0] =~ s/'/\\'/;
			$line[0] =~ s/\\/\\\\/g;
			$line[0] =~ s/'/\\'/;
			unless (eval("\${$current_section}{'$line[0]'}='$test[0]'"))
			{
				print "Error message: $@\n";
			}
		}
	} # end if ($input =~ /=/i)
} # end while (<FILE>)


close(FILE);

print "Done!\nReading $file_to_open...";

open(FILE,$file_to_open);

LINE: while($input = <FILE>)
{
	chomp $input; #chomp off the newline character
	$input =~ s/\\#/^~/;
	$input =~ s/\s*#.*//;
	$input =~ s/\^~/#/;
	$input =~ s/^\s+//;
	if ($input eq "")
	{
		next LINE;
	}

	while (($count,$count2) = each %aliases)
	{
		$input=~ s/$count/$count2/ig;
	}
	@currentList=@conditionList;
	@currents=@conditions;
	@currentNum=@conditionNum;
	$count2=0;
	CONDITION: foreach $cond (@conditionList)
	{
		if ($input=~/$cond/i)
		{
			if ($cond =~/switch/i and $input !~ /is/i and $input !~ /=/i)
			{
				last CONDITION;
			}
				
			print "$input has $cond inside. (CONDITION)\n" if ($debug);
			undef @line;
			@line = ("00","00","00","00","00","00","00","00",
				    "00","00","00","00","00","00","00","00",
				    "00","00","00","00");

			for ($count = $conditionNum[$count2]+1; $conditions[$count] =~ /\D/ ;$count++)
			{
				&add_hex_code_to_line_array(&parse_current,1);
			}
			print "Damage: '$input'\n" if ($debug);
			push(@printout,"Condition");
			push(@printout,join(":",@currentPlayers) . ":") if (@currentPlayers);
			undef @currentPlayers;
			$line[19]="2" if ($input =~ /disabled/i);
			for ($_=0;$_ <= $#line;$_++)
			{
				if ($line[$_] !~ /\d/)
				{
				push(@printout,$line[$_]);
				$_+=length($line[$_])-1;
				}				
				elsif ($line[$_] > 65535)
				{
					$line[$_]=sprintf("%s",pack('V',$line[$_]));
					push(@printout,$line[$_]);
					$_+=3;
				}
				elsif ($line[$_] > 255)
				{
					$line[$_]=sprintf("%s",pack('v',$line[$_]));
					push(@printout,$line[$_]);
					$_++;
				}
				else
				{
					push(@printout,pack('C',$line[$_]));
				}
				if ($_ < 16)
				{
					print "$_ ". sprintf("0%X ",$line[$_]) if ($debug);
				}
				else
				{
					print "$_ ". sprintf("%X ",$line[$_]) if ($debug);
				}
			}	
			print "\n" if ($debug);
			last CONDITION;
		}
		$count2++;		
	}
	$,=",";
	$count2=0;
	@currentList=@actionList;
	@currents=@actions;
	@currentNum=@actionNum;

	ACTION: foreach $cond (@actionList)
	{
		if ($input=~/$cond/i)
		{
			print "$input has $cond inside. (ACTION)\n" if ($debug);
			undef @line;
			@line = ("00","00","00","00","00","00","00","00",
				    "00","00","00","00","00","00","00","00",
				    "00","00","00","00","00","00","00","00",
				    "00","00","00","00","00","00","00","00");
			for ($count = $actionNum[$count2]+1; $actions[$count] =~ /\D/ ;$count++)
			{
				&add_hex_code_to_line_array(&parse_current,2);
			}
			print "Damage: '$input'\n" if ($debug);
			$line[30]="2" if ($input =~ /disabled/i);
			push(@printout,"Action");
			for ($_=0;$_ <= $#line;$_++)
			{
				if ($line[$_] !~ /\d/)
				{
				push(@printout,$line[$_]);
				$_+=length($line[$_])-1;
				}					
				elsif ($line[$_] > 65535)
				{
					$line[$_]=sprintf("%s",pack('V',$line[$_]));
					push(@printout,$line[$_]);
					$_+=3;
				}
				elsif ($line[$_] > 255)
				{
					$line[$_]=sprintf("%s",pack('v',$line[$_]));
					push(@printout,$line[$_]);
					$_++;
				}
				else
				{
					push(@printout,pack('C',$line[$_]));
				}
			
				if ($_ < 16)
				{
					print "$_ ". sprintf("0%X ",$line[$_]) if ($debug);
				}
				else
				{
					print "$_ ".sprintf("%X ",$line[$_]) if ($debug);
				}
				
			}	
			print "\n" if ($debug);

			last ACTION;
		}
		$count2++;		
	}
	
	while(($temp_integer,$temp_string)= each %players)
	{
		if ($input =~ /$temp_string/i)
		{
			print "$temp_string -- (hex output: " . sprintf("%2X",$temp_integer) .")\n" if ($debug);
			push(@currentPlayers,$temp_integer);			
		}
	}


	

}
print "Done!\nWriting $file_to_write...";
open (OUTPUT, ">$file_to_write") or &error(__FILE__,__LINE__, "Cannot make new file $file_to_write");
binmode OUTPUT;
print OUTPUT "qw6" . pack("C",00);

$count=0;
while ($count<=$#printout)
{
	$count2=0;
	undef @currentPlayers;
	for (;$count<=$#printout;++$count)
	{
		if ($printout[$count] eq "Action")
		{
			last;
		}
		if ($printout[$count] eq "Condition")
		{
			if ($printout[$count + 1] =~ /.+:$/)
			{
				$printout[++$count] =~ s/:$//;
				@currentPlayers=split(/:/,$printout[$count]);
			}
			$count2++;
			print "\n" if ($debug);
			next;
		}
		print OUTPUT $printout[$count];
		print unpack("C",$printout[$count]) . " $count "  if ($debug);
	
	}
	if ($count2 == 0)
	{
		print OUTPUT pack("C",00) x 17 . pack("C",22) . pack("C",00) x 2;
		$count2=1;
	}
	
	for (;$count2<16;++$count2)
	{
		print OUTPUT (pack("C",00) x 20);
	}
	

	$count2=0;
	
	for (;$count<=$#printout;++$count)
	{
		if ($printout[$count] eq "Condition")
		{
			last;
		}
		
		if ($printout[$count] eq "Action")
		{
			$count2++;
			print "\n"  if ($debug);
		}
		else
		{
			print OUTPUT $printout[$count];
		}
	}
	
	for (;$count2<64;++$count2)
	{
		print OUTPUT (pack("C",00) x 32);
	}
		print OUTPUT (pack("C",00) x 6);
		
		$count3=0;
		COUNT: for ($count2=0;$count2<=25;++$count2)
		{
			foreach (@currentPlayers)
			{
				if ($count2 == $_)
				{
					print OUTPUT (pack("C",01));
					next COUNT;
				}
			}
			print OUTPUT (pack("C",00));		
		}
}
print OUTPUT (pack("C",00) x 2);

close(OUTPUT);
close(FILE);
print "Done!\nYou can now import $file_to_write into your maps.\n";

sub add_hex_code_to_line_array
{
	my ($translation, $hex_code, $number_to_modify);
	$translation=$_[0];
	$hex_code=$_[3];
	$number_to_modify=$_[$_[4]];
	unless ($number_to_modify == -1)
	{
		&error(__FILE__,__LINE__,"$translation could not be found inside $input")
			unless ($input =~ /$translation/i);				
		$input =~ s/$translation//i;
		$line[$number_to_modify]="$hex_code";
		$,=",";
	}
}


sub parse_current
{
	my $prob;
	$prob="";
	if ($currents[$count] =~ /handler/i)
	{
		print "$currents[$currentNum[$count2]] -- (hex output: " . sprintf("%2X",$currents[$currentNum[$count2]-1]) . ")\n"  if ($debug);
		if ($currents[$currentNum[$count2]] =~ /\.\*/)
		{
			return ($`,17,28,$currents[$currentNum[$count2]-1]); #$` is the part of the string before the part that matched
		}
		return($currents[$currentNum[$count2]],17,28,$currents[$currentNum[$count2]-1]);
	}
	
	if ($currents[$count] =~ /player/i)
	{
		while(($temp_integer,$temp_string)= each %players)
		{
			if ($input =~ /$temp_string/i)
			{
				print "$temp_string -- (hex output: " . sprintf("%2X",$temp_integer) .")\n"  if ($debug);
				$current_section=keys %players;
				return ($temp_string,6,18,$temp_integer);
			}
			
		}
		$prob = "Couldn't find any player info in $input";
	}
	
	if ($currents[$count] =~ /number/i)
	{

		if ($currentList[3] eq $actionList[3])
		{
			if ($input =~ /\d+/i)
			{
				return ("$&",10,22,$&);
			}	
		}
		elsif (($temp_integer) = $input =~ /(\d+) or more/i)
		{
			print "$temp_integer or more -- (hex output: ". sprintf("%2X",$1) . " 00)\n"  if ($debug);
			$input =~ s/ or more//i;
			return ("$temp_integer",10,22,$temp_integer);
		}
		elsif (($temp_integer) = $input =~ /(\d+) or (less|fewer)/i)
		{
			print "$temp_integer or less -- (hex output: " . sprintf("%2X",$1) . " 01)\n"  if ($debug);
			$input =~ s/ or less//i;
			$line[16]="1"; # 1 = or less
			return ("$temp_integer",10,22,$temp_integer);
		}

		$prob = "$input does not contain NUMBER or more / NUMBER or less";
	}

	if ($currents[$count] =~ /switchnum/i)
	{
		if ($input =~ /\d+/)
		{
			if ($&<=32 and $&>=1)
			{
				print "$& -- (hex output: " . sprintf("%2X",$&) . ")\n"  if ($debug);
				return ($&,18, 22, ($& - 1));
			}
			$prob = "The switch number was not between 1 and 32";
		}
		else
		{
			$prob = "$input does not contain a switch number -- which switch to set";
		}
	}


	if ($currents[$count] =~ /aiscript/i)
	{
		while (($temp_integer,$temp_string) = each %aiscripts)
		{
#			print "< $input --> $temp_string >\n";
			if ($input =~ /$temp_string/i)
			{
				keys %aiscripts;
				print "\"$temp_string\" -- (hex output: " . $temp_integer .")\n"   if ($debug);
				return ($temp_string, -1, 22, $temp_integer);
			}
		}
	}
	
	if ($currents[$count] =~ /location/i)
	{
		if ($input =~ /\"(.+)\"/)
		{
			print "\"$1\" -- (hex output: " . $1 .")\n"  if ($debug);
			return ('"' . $1 . '"', -1, -1, $1);
		}
		if ((($currents[$currentNum[$count2]-1] eq "7" or 
			$currents[$currentNum[$count2]-1] eq "17") and
			$currentList[1] eq $conditionList[1])
			                    or
			(($currents[$currentNum[$count2]-1] eq "18" or 
			$currents[$currentNum[$count2]-1] eq "23" or
			$currents[$currentNum[$count2]-1] eq "25" or
			$currents[$currentNum[$count2]-1] eq "16") and
			$currentList[1] eq $actionList[1]))
		{
			return("",17,28,$currents[$currentNum[$count2+1]-1]);
		}
		$prob = "no location, location needed";	
		
	}
	if ($currents[$count] =~ /text/i or $currents[$count] =~ /sound/i)
	{
		print "insert text/sound here\n"  if ($debug);
		return("",-1,-1,"");
	}
	


	if ($currents[$count] =~ /resourcetype/i)
	{
		if ($input =~ /ore and gas/i)
		{
			$temp_string="ore and gas";
			$temp_integer = 2;
		}	
		elsif ($input =~ /\bore/i)
		{
			$temp_string="ore";
			$temp_integer = 0;
		}
		elsif ($input =~ /\bgas/i)
		{
			$temp_string="gas";
			$temp_integer = 1;
		}
		else
		{
		&error(__FILE__,__LINE__,"cant find ore inside the string ('$input')");
		}
		print "$temp_string -- (hex output: ". sprintf("%2X",$temp_integer) . ")\n"  if ($debug);
		return ($temp_string,13,26,$temp_integer);
	}

	if ($currents[$count] =~ /switchvalue/i)
	{
	
		if ($input =~ /set/i)
		{
			
			$temp_string="set";
			if ($currents[$count] =~ /switchvalue2/)
			{
				$temp_integer = 7;
			}			
			elsif ($actionList[3] eq $currentList[3])
			{
				$temp_integer = 4; # 4
			}
			else
			{
				$temp_integer = 2;
			}

			
		}
		elsif ($input =~ /clear/i)
		{
			$temp_string="clear";

			if ($actionList[2] eq $currentList[2])
			{
				$temp_integer = 5;
			}
			else
			{
				$temp_integer = 3;
			}
			
		}
		elsif ($input =~ /toggle/i)
		{
			$temp_string="toggle";
			$temp_integer = 9;
		}
		else
		{
		&error(__FILE__,__LINE__,"('$input') does not contain set, clear, or toggle");
		}
		print "$temp_string -- (hex output: " . sprintf("%2X",$temp_integer) . ")\n"  if ($debug);
		return ($temp_string,16,29,$temp_integer);
	}



	if ($currents[$count] =~ /unit/i)
	{
		while(($temp_integer,$temp_string)= each %units)
		{
			if ($temp_integer == 5)
			{
				if ($input =~ /$temp_string/i and $input !~/Siege ?Tank ?\(?Siege/)
				{
				print "$temp_string -- (hex output: " . sprintf("%2X",$temp_integer) . ")\n"  if ($debug);
				$current_section = keys %units;

				return ($temp_string,14,26,$temp_integer);
				}
			}
			elsif ($input =~ /$temp_string/i)
			{
				print "$temp_string -- (hex output: " . sprintf("%2X",$temp_integer) . ")\n"  if ($debug);
				$current_section = keys %units;

				return ($temp_string,14,26,$temp_integer);
			}
		}
		$prob = "'$input' does not contain any valid units.";
	}

	if ($currents[$count] =~ /scoretype/i)
	{
		while(($temp_integer,$temp_string)= each %scoretype)
		{
			if ($input =~ /$temp_string/i)
			{
				print "$temp_string -- (hex output: " . sprintf("%2X",$temp_integer) . ")\n"  if ($debug);
				$current_section = keys %scoretype;
				return ($temp_string,18,22,$temp_integer);
			}
		}
		$prob = "'$input' does not contain any valid score types.";
	}
	
	
	if ($prob)
	{
		&error(__FILE__,__LINE__,$prob);
	}
	&error(__FILE__,__LINE__,"Sorry, '$currents[$count]' is not supported yet.");
}




sub error
{

my ($file,$line,$error_message)=@_;

print "\nError on $file, line $line.  Error message: $error_message\n";
exit(0);
}
